% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_dist.R
\name{tsdist_cor}
\alias{tsdist_cor}
\title{Absolute, positive, or negative correlation distance.}
\usage{
tsdist_cor(ts1, ts2, cor_type = "abs", sig_test = FALSE, sig_level = 0.01, ...)
}
\arguments{
\item{ts1}{Array. Time series 1}

\item{ts2}{Array. Time series 2}

\item{cor_type}{String. "abs" (default), "+", or "-". "abs" considers the
correlation absolute value. "+" only positive correlations and "-" only
negative correlations.}

\item{sig_test}{Run a statistical test. Return 0 if significant or 1 otherwise.}

\item{sig_level}{The significance level to test if correlation is significant.}

\item{...}{Additional parameters to cor.test() function.}
}
\value{
Real value [0,1] where 0 means perfect positive (or negative
if positive_cor==FALSE) correlation and 1 no positive (or negative
if positive_cor==FALSE) correlation.
}
\description{
Considering r the person correlation coefficient, this function returns
either 1 - abs(r) if cor_type=="abs", 1 - pmax(0, r) if cor_type == "+",
or 1 - pmax(0, r * -1) if cor_type == "-". Another possibility is to
run a significance test to verify if the r is significant.
}
