% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tryLog.R
\name{tryLog}
\alias{tryLog}
\title{Try an expression with condition logging and error recovery}
\usage{
tryLog(
  expr,
  write.error.dump.file = getOption("tryCatchLog.write.error.dump.file", FALSE),
  write.error.dump.folder = getOption("tryCatchLog.write.error.dump.folder", "."),
  silent.warnings = getOption("tryCatchLog.silent.warnings", FALSE),
  silent.messages = getOption("tryCatchLog.silent.messages", FALSE),
  include.full.call.stack = getOption("tryCatchLog.include.full.call.stack", TRUE),
  include.compact.call.stack = getOption("tryCatchLog.include.compact.call.stack",
    TRUE),
  execution.context.msg = ""
)
}
\arguments{
\item{expr}{R expression to be evaluated}

\item{write.error.dump.file}{\code{TRUE}: Saves a dump of the workspace and the call stack named
\code{dump_<YYYYMMDD>_at_<HHMMSS.sss>_PID_<process id>.rda}.
This dump file name pattern shall ensure unique file names in parallel processing scenarios.}

\item{write.error.dump.folder}{\code{path}: Saves the dump of the workspace in a specific folder instead of the working directory}

\item{silent.warnings}{\code{TRUE}: Warnings are logged only, but not propagated to the caller.\cr
\code{FALSE}: Warnings are logged and treated according to the global
setting in \code{\link{getOption}("warn")}. See also \code{\link{warning}}.}

\item{silent.messages}{\code{TRUE}: Messages are logged, but not propagated to the caller.\cr
\code{FALSE}: Messages are logged and propagated to the caller.}

\item{include.full.call.stack}{Flag of type \code{\link{logical}}:
Shall the full call stack be included in the log output? Since the full
call stack may be very long and the compact call stack has enough details
normally the full call stack can be omitted by passing \code{FALSE}.
The default value can be changed globally by setting the option \code{tryCatchLog.include.full.call.stack}.
The full call stack can always be found via \code{\link{last.tryCatchLog.result}}.}

\item{include.compact.call.stack}{Flag of type \code{\link{logical}}:
Shall the compact call stack (including only calls with source code references)
be included in the log output? Note: If you ommit both the full and compact
call stacks the message text will be output without call stacks.
The default value can be changed globally by setting the option \code{tryCatchLog.include.compact.call.stack}.
The compact call stack can always be found via \code{\link{last.tryCatchLog.result}}.}

\item{execution.context.msg}{a text identifier (eg. the PID or a variable value) that will be added to msg.text
for catched conditions. This makes it easier to identify the runtime state that caused
a condition esp. in parallel execution scenarios.
The value must be of length 1 and will be coerced to character.
Expressions are not allowed.
The added output has the form: \code{{execution.context.msg: your_value}}}
}
\value{
The value of the expression (if \code{expr} is evaluated without an error.\cr
        In case of an error: An invisible object of the class \code{"try-error"} containing the error message
        and error condition as the \code{"condition"} attribute.
}
\description{
\code{tryLog} is implemented by calling \code{\link{tryCatchLog}}
and traps any errors that occur during the evaluation of an expression without stopping the execution
of the script (similar to \code{\link{try}}). Errors, warnings and messages are logged.
In contrast to \code{\link{tryCatchLog}} it returns but does not stop in case of an error and therefore does
not have the \code{error} and \code{finally} parameters to pass in custom handler functions.
}
\details{
\code{tryLog} is implemented using \code{\link{tryCatchLog}}. If you need need more flexibility for
         catching and handling errors use the latter.
         Error messages are never printed to the \code{\link{stderr}} connection but logged only.
}
\examples{
tryLog(log(-1))   # logs a warning (logarithm of a negative number is not possible)
tryLog(log("a"))  # logs an error
tryCatchLog(log(-1), execution.context.msg = Sys.getpid())
}
\seealso{
\code{\link{tryCatchLog}},
         \code{\link{last.tryCatchLog.result}}
}
