% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/product.R
\name{products}
\alias{products}
\title{Find products by name or brand}
\usage{
products(
  product = NA,
  brand = NA,
  regex = TRUE,
  ignore_case = TRUE,
  barcode = NA,
  head = FALSE,
  ...
)
}
\arguments{
\item{product}{Filter by product name (treated as a regular expression).}

\item{brand}{Filter by product brand (treated as a regular expression).}

\item{regex}{Should filter be treated as a Regular Expression?}

\item{ignore_case}{Should case be ignored?}

\item{barcode}{Filter by barcode.}

\item{head}{Return the data (\code{FALSE}) or the number of records (\code{TRUE})?}

\item{...}{Arguments passed through to \code{paginate()}.}
}
\value{
Product details as a \code{data.frame} if \code{head} is \code{FALSE}, otherwise the number of products that would be returned.
}
\description{
Find products by name or brand
}
\examples{
\dontrun{
products(product = "coffee")
products(brand = "Illy")
products(product = "coffee", brand = "Illy")
products(product = "coffee", brand = "Illy", head = TRUE)
}
}
