% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_item.R
\name{download_item}
\alias{download_item}
\title{Download NHS TRUD item}
\usage{
download_item(
  item,
  directory = ".",
  download_file = "archive",
  TRUD_API_KEY = NULL,
  release = NULL
)
}
\arguments{
\item{item}{An integer, the item to be downloaded.}

\item{directory}{Path to the directory to which this item will be downloaded
to. This is set to the current working directory by default.}

\item{download_file}{The item file to be downloaded. Valid values:
\itemize{
\item \code{"archive"} (the release item)
\item \code{"checksum"}
\item \code{"signature"}
\item \code{"publickKey"}
}}

\item{TRUD_API_KEY}{A string. The name of an environmental variable
containing your TRUD API key. If \code{NULL} (default) this is assumed to be
called \code{TRUD_API_KEY}.}

\item{release}{The name of a specific release ID to be downloaded (this can
be ascertained using \code{\link[=get_item_metadata]{get_item_metadata()}}). If \code{NULL} (default), then the
latest item release will be downloaded.}
}
\value{
The file path to the downloaded file, returned invisibly.
}
\description{
Downloads files for a specified NHS TRUD item (requires a subscription). By
default this is the latest release.
}
\examples{
\dontrun{
 # Download Community Services Data Set pre-deadline extract XML Schema
 x <- download_item(394, directory = tempdir())

 # List downloaded files
 unzip(x, list = TRUE)

 # Download a previous release
 release <- get_item_metadata(394)$releases[[2]]$id

 y <- download_item(394, directory = tempdir(), release = release)

 unzip(y, list = TRUE)
}

# An informative error is raised if your API key is invalid or missing
try(download_item(394, TRUD_API_KEY = "INVALID_API_KEY"))
}
