% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tropr.R
\name{as.data.frame.tropr.content}
\alias{as.data.frame.tropr.content}
\title{Convert TV Tropes content to data frame}
\usage{
\method{as.data.frame}{tropr.content}(x, ...,
  stringsAsFactors = default.stringsAsFactors())
}
\arguments{
\item{x}{\code{tropr.content} object}

\item{...}{additional arguments to be passed to \code{data.frame}}

\item{stringsAsFactors}{logical: should the character vector be converted to
a factor?}
}
\value{
\code{data.frame} with tv trope contents
}
\description{
Convert TV Tropes content to data frame
}
\examples{
library(tropr)

# Use any TV Tropes page url that you analyses
.url <- "http://tvtropes.org/pmwiki/pmwiki.php/Main/SenseiChan"

\dontrun{
content <- trope_content(.url)
.df <- as.data.frame(content)
}
}
