% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triplot.R
\name{plot.triplot}
\alias{plot.triplot}
\title{Plots triplot}
\usage{
\method{plot}{triplot}(
  x,
  absolute_value = FALSE,
  add_importance_labels = FALSE,
  show_model_label = FALSE,
  abbrev_labels = 0,
  add_last_group = TRUE,
  axis_lab_size = 10,
  text_size = 3,
  bar_width = 5,
  margin_mid = 0.3,
  ...
)
}
\arguments{
\item{x}{triplot object}

\item{absolute_value}{if TRUE, aspect importance values will be drawn as
absolute values}

\item{add_importance_labels}{if TRUE, first plot is annotated with values of
aspects importance on the bars}

\item{show_model_label}{if TRUE, adds subtitle with model label}

\item{abbrev_labels}{if greater than 0, labels for axis Y in single aspect
importance plot will be abbreviated according to this parameter}

\item{add_last_group}{if TRUE and \code{type = predict}, plot will
draw connecting line between last two groups at the level of 105% of the
biggest importance value, for \code{model} this line is always drawn at
the baseline value}

\item{axis_lab_size}{size of labels on axis}

\item{text_size}{size of labels annotating values of aspects importance and
correlations}

\item{bar_width}{bar width in the first plot}

\item{margin_mid}{size of a right margin of a middle plot}

\item{...}{other parameters}
}
\value{
plot
}
\description{
Plots triplot that sum up automatic aspect/feature importance grouping
}
\examples{
library(DALEX)
set.seed(123)
apartments_num <- apartments[,unlist(lapply(apartments, is.numeric))]
apartments_num_lm_model <- lm(m2.price ~ ., data = apartments_num)
apartments_num_new_observation <- apartments_num[30, ]
explainer_apartments <- explain(model = apartments_num_lm_model,
                                data = apartments_num[,-1],
                                y = apartments_num[, 1],
                                verbose = FALSE)
apartments_tri <- calculate_triplot(x = explainer_apartments,
 new_observation = apartments_num_new_observation[-1])
plot(apartments_tri)

}
