context("test-distances")

test_that("distance gives comparable values", {
  expect_equivalent(as.numeric(round(quantile(trackDistance(walrus818)))), c(0, 98, 445, 1433, 309075))
  
  expect_equivalent(round(homedist(walrus818)), 
                    c(`353` = 194120, `354` = 515916, `355` = 513436, `356` = 516914, 
                      `357` = 519706, `358` = 515748, `359` = 514025, `361` = 512403, 
                      `362` = 199096, `366` = 516366, `367` = 63337, `368` = 510726, 
                      `443` = 518193, `444` = 454477)
                    
                    
  )
  expect_equivalent( round(homedist(walrus818, cbind(0, 0))), 
                     c(`353` = 284118, `354` = 359920, `355` = 354514, `356` = 412693, 
                       `357` = 374616, `358` = 369769, `359` = 356057, `361` = 354525, 
                       `362` = 310850, `366` = 356839, `367` = 313050, `368` = 353936, 
                       `443` = 371292, `444` = 289451)
  )
  
  wll <- reproj(walrus818, "+proj=longlat +datum=WGS84")
  expect_equivalent(round(homedist(wll), digits = 2), 
                    c(`353` = 194.09, `354` = 515.84, `355` = 513.37, `356` = 516.83, 
                      `357` = 519.62, `358` = 515.67, `359` = 513.95, `361` = 512.33, 
                      `362` = 199.06, `366` = 516.29, `367` = 63.32, `368` = 510.65, 
                      `443` = 518.11, `444` = 454.42)
                    
  )
  
  expect_equivalent(round(homedist(wll, cbind(0, 0)), digits = 2), 
                    c(`353` = 12291.34, `354` = 12559.53, `355` = 12554.1, `356` = 12603.02, 
                      `357` = 12574.18, `358` = 12569.34, `359` = 12555.6, `361` = 12554.08, 
                      `362` = 12298.52, `366` = 12556.27, `367` = 12091.73, `368` = 12553.55, 
                      `443` = 12570.9, `444` = 12489.13)
                    )
})
