% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tricolore.R
\name{Pertube}
\alias{Pertube}
\title{Compositional Pertubation}
\usage{
Pertube(P, c = rep(1/3, 3))
}
\arguments{
\item{P}{n by m matrix of compositions {p1, ..., pm}_i for i=1,...,n.}

\item{c}{Compositional pertubation vector {c1, ..., cm}.}
}
\value{
n by m matrix of pertubated compositions.
}
\description{
Pertubate a compositional data set by a compositional vector.
}
\examples{
P <- prop.table(matrix(runif(12), 4), margin = 1)
cP <- tricolore:::Pertube(P, 1/tricolore:::Centre(P))
tricolore:::Centre(cP)

}
\references{
Von Eynatten, H., Pawlowsky-Glahn, V., & Egozcue, J. J. (2002).
Understanding perturbation on the simplex: A simple method to better
visualize and interpret compositional data in ternary diagrams.
Mathematical Geology, 34(3), 249-257.

Pawlowsky-Glahn, V., Egozcue, J. J., & Tolosana-Delgado, R. (2007). Lecture
Notes on Compositional Data Analysis. Retrieved from
https://dugi-doc.udg.edu/bitstream/handle/10256/297/CoDa-book.pdf
}
\keyword{internal}
