% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tricolore.R
\name{ColorKey}
\alias{ColorKey}
\title{Ternary Balance Scheme Legend}
\usage{
ColorKey(breaks, h_, c_, l_, contrast, center, spread)
}
\arguments{
\item{breaks}{Number of breaks in the discrete color scale. An integer >0.
Values above 99 imply no discretization.}

\item{h_}{Primary hue of the first ternary element in angular degrees [0, 360].}

\item{c_}{Maximum possible chroma of mixed colors [0, 200].}

\item{l_}{Lightness of mixed colors [0, 100].}

\item{contrast}{Lightness contrast of the color scale [0, 1).}

\item{center}{Ternary coordinates of the grey-point.}

\item{spread}{Spread of the color scale around center > 0.}
}
\description{
Plot a ternary balance scheme legend.
}
\examples{
tricolore:::ColorKey(breaks = 5, h_ = 0, c_ = 140, l_ = 70, contrast = 0.5,
                     center = rep(1/3, 3), spread = 1)

}
\keyword{internal}
