% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights_at_dose.R
\name{weights_at_dose}
\alias{weights_at_dose}
\alias{weights_at_dose.default}
\alias{weights_at_dose.crm_fit}
\title{Get the weights of patient outcomes at the doses under investigation.}
\usage{
weights_at_dose(x, dose, ...)

\method{weights_at_dose}{default}(x, dose = NULL, ...)

\method{weights_at_dose}{crm_fit}(x, dose = NULL, ...)
}
\arguments{
\item{x}{An R object of class \code{"dose_finding_fit"}}

\item{dose}{Optional integer, at which dose-level? Omit to get data on all doses.}

\item{...}{arguments passed to other methods}
}
\value{
list if \code{dose} omitted, numerical vector if \code{dose} provided.
}
\description{
Get the weights of patient outcomes at the doses under investigation.
}
\examples{
\dontrun{
# CRM example
fit <- stan_crm(skeleton = c(0.1, 0.2, 0.35, 0.6), target = 0.2,
                model = 'empiric', beta_sd = sqrt(1.34), seed = 123,
                doses = c(1, 1, 2, 2, 2),
                tox   = c(0, 0, 0, 0, 0),
                weights = c(1, 1, 0.9, 0.1, 0.1))
l <- weights_at_dose(fit)

length(l)  # 4
l[[1]]  # c(1, 1)
l[[2]]  # c(0.9, 0.1, 0.1)
l[[3]]  # c()

weights_at_dose(fit, dose = 2)  # c(0.9, 0.1, 0.1)
}
}
