% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_at_dose.R
\name{n_at_dose}
\alias{n_at_dose}
\alias{n_at_dose.dose_finding_fit}
\title{Get the number of patients treated at the doses under investigation.}
\usage{
n_at_dose(x, dose, ...)

\method{n_at_dose}{dose_finding_fit}(x, dose = NULL, ...)
}
\arguments{
\item{x}{An R object of class \code{"dose_finding_fit"}}

\item{dose}{Optional integer, at which dose-level? Omit to get data on all doses.}

\item{...}{arguments passed to other methods}
}
\value{
integer vector
}
\description{
Get the number of patients treated at the doses under investigation.
}
\examples{
\dontrun{
# CRM example
target <- 0.2
fit <- stan_crm('1N 2N 3T', skeleton = c(0.1, 0.2, 0.35, 0.6),
                 target = target, model = 'empiric', beta_sd = sqrt(1.34),
                 seed = 123)
n_at_dose(fit)            # c(1, 1, 1, 0)
n_at_dose(fit, dose = 3)  # 1
}
}
