% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_parse_outcomes.R
\name{df_parse_outcomes}
\alias{df_parse_outcomes}
\title{Parse a string of dose-finding trial outcomes to binary vector notation.}
\usage{
df_parse_outcomes(outcome_string, as.list = TRUE)
}
\arguments{
\item{outcome_string}{character string, conveying doses given and outcomes
observed.}

\item{as.list}{TRUE (the default) to return a \code{list};
FALSE to return a \code{data.frame}}
}
\value{
If \code{as.list == TRUE}, a list with elements \code{tox},
\code{doses} and \code{num_patients}. These elements are congruent with those
of the same name in \code{crm_params}, for example.
If \code{as.list == FALSE}, a data.frame with columns \code{tox} and
\code{doses}.
}
\description{
Parse a string of dose-finding trial outcomes to the binary
vector notation required by Stan for model invocation. The outcome string
describes the doses given and outcomes observed. The format of the string is
the pure phase I analogue to that described in Brock et al. (2017).
The letters T and N are used to represents patients that experienced
(T)oxicity and (N)o toxicity. These letters are concatenated after numerical
dose-levels to convey the outcomes of cohorts of patients.
For instance, \code{2NNT} represents a cohort of three patients that were
treated at dose-level 2, one of whom experienced toxicity, and two that did
not. The results of cohorts are separated by spaces. Thus, \code{2NNT 1NN}
extends our previous example, where the next cohort of two were treated at
dose-level 1 and neither experienced toxicity. See examples.
}
\examples{
x = df_parse_outcomes('1NNN 2NTN 3TTT')
x$num_patients  # 9
x$doses         # c(1, 1, 1, 2, 2, 2, 3, 3, 3)
x$tox           # c(0, 0, 0, 0, 1, 0, 1, 1, 1)
sum(x$tox)      # 4

}
\references{
Brock, K., Billingham, L., Copland, M., Siddique, S., Sirovica, M., & Yap, C.
(2017). Implementing the EffTox dose-finding design in the Matchpoint trial.
BMC Medical Research Methodology, 17(1), 112.
https://doi.org/10.1186/s12874-017-0381-x
}
