% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efftox.R
\name{efftox_analysis_to_df}
\alias{efftox_analysis_to_df}
\title{EffTox analysis to data.frame}
\usage{
efftox_analysis_to_df(x)
}
\arguments{
\item{x}{An \code{\link{efftox_analysis}}}
}
\value{
a \code{data.frame}
}
\description{
Convenient function to turn an \code{\link{efftox_analysis}}
into a \code{data.frame}.
}
\examples{
dat <- efftox_parameters_demo()
dat$num_patients <- 3
dat$eff <- c(0, 1, 1)
dat$tox <- c(0, 0, 1)
dat$doses <- c(1, 2, 3)
fit <- rstan::sampling(stanmodels$EffTox, data = dat)
decision <- efftox_process(dat, fit)
df <- efftox_analysis_to_df(decision)
round(df$Utility, 2) == c(-0.64, 0.04, 0.24, -0.05, -0.19)

}
