## Copyright (C) 2015-2018 Thorsten Pohlert, GPL-3
#' @name maxau
#' @docType data
#' 
#' @title Annual suspended sediment concentration and flow data, River Rhine
#' 
#' @description
#'  Annual time series of average suspended sediment
#'  concentration (s) in mg/l and average discharge (Q) in m^3 / s at
#'  the River Rhine, 1965.1-2009.1
#'
#' @usage data(maxau)
#' 
#' @format
#' a time series object of class "mts"
#' 
#' \itemize{
#' \item s. first column, suspended sediment concentration
#' \item Q. second column, average discharge
#' }
#' 
#' @source
#' Bundesanstalt für Gewässerkunde, Koblenz, Deutschland
#' (Federal Institute of Hydrology, Koblenz, Germany)
#'
#' @examples
#' data(maxau)
#' plot(maxau)
#' @keywords datasets
NULL

