% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtrellis.R
\name{qtrellis}
\alias{qtrellis}
\title{Quick trelliscope display for data frame-like inputs}
\usage{
qtrellis(x, panel = NULL, cog = NULL, by = NULL, layout = c(1, 1),
  conn = getOption("vdbConn"), ...)
}
\arguments{
\item{x}{either a data frame}

\item{panel}{a function taking one argument (which will be a subset of the input data frame) and returning a plot}

\item{cog}{an optional cognostics funtion to be applied to each subset}

\item{by}{if the input is a data frame, a character vector of column names to split the data by}

\item{layout}{a vector indicating the number of rows and columns to arrange the panels in by default}

\item{conn}{VDB connection info, typically stored in options("vdbConn") at the beginning of a session, and not necessary to specify here if a valid "vdbConn" object exists or if you would like to use a temporary one for this display}

\item{\ldots}{parameters passed to \code{\link{makeDisplay}} - most importantly \code{name}, \code{group} (see note below), \code{width}, and \code{height}}
}
\description{
Quick trelliscope display for data frame-like inputs
}
\note{
If you don't have a vdb connection set up (see \code{\link{vdbConn}}), a temporary one will be created and used, and you can think of the plot as disposable.  If you would like the plot to persist, set up a vdb connection.  Likewise, if you don't supply \code{name} and \code{group}, the plot will be stored under defaults "qtrellis_plot" and "__qtrellis", and a subsequent call will cause the previous display with this name and group to be replaced.  Therefore, if you want your display to persist, make sure a vdb connection has been set up prior to calling this function, and give it a unique name.
}
\examples{
\dontrun{
panel <- function(x)
  xyplot(Sepal.Width ~ Sepal.Length, data = x)

p <- datadr::divide(iris, by = "Species") \%>\%
  qtrellis(panel, layout = c(1, 3))
p

# data frame input (need to specify 'by')
iris \%>\% qtrellis(panel, by = "Species")

# dplyr grouped tbl input
library(dplyr)
p <- iris \%>\%
  group_by(Species) \%>\%
  qtrellis(panel, layout = c(1, 3))
p
}
}
