% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view.R
\name{view}
\alias{view}
\title{View a Display or Run Shiny Display Viewer}
\usage{
view(name = NULL, group = NULL, state = NULL, openBrowser = TRUE,
  conn = getOption("vdbConn"), port = getOption("trelliscopePort"),
  copyFiles = TRUE)
}
\arguments{
\item{name, group}{optional parameters to load the viewer with a pre-specified display - if not specified, the viewer will launch with a list to choose from}

\item{state}{an optional list of state variables to set the default viewing state for layout, sorting, filtering, and labels (see details)}

\item{openBrowser}{should the browser be automatically launched?}

\item{conn}{VDB connection info, typically stored in options("vdbConn") at the beginning of a session, and not necessary to specify here if a valid "vdbConn" object exists}

\item{port}{what port to use for the viewer - if not specified, will look for "trelliscopePort" set in R's global options, followed by a search for a system-level environment variable "TRELLISCOPE_PORT".  If none of these are defined, a random port assigned provided by shiny will be used.}

\item{copyFiles}{should updated viewer files be copied over to VDB directory?}
}
\description{
View a display or run Shiny display viewer
}
\examples{
library(ggplot2)

vdbConn(tempfile(), autoYes = TRUE)

# make a simple display
d <- divide(iris, by = "Species")
makeDisplay(d, name = "sl_vs_sw",
  panelFn = function(x)
    qplot(Sepal.Width, Sepal.Length, data = x))

\dontrun{
# open viewer with default providing list of displays to veiw
view()

# open viewer on port 8100
view(port = 8100)

# make port 8100 the default port for all future calls to view()
options(trelliscopePort = 8100)

# open viewer directly to "sl_vs_sw"
view(name = "sl_vs_sw")

# open viewer directly to "sl_vs_sw" and set intial state
view(state = stateSpec(
  name = "sl_vs_sw",
  layout = list(nrow = 1, ncol = 3),
  labels = c("panelKey", "Species")))
}
}

