% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepanel.R
\name{prepanel}
\alias{prepanel}
\title{Prepanel Function for Trelliscope Displays}
\usage{
prepanel(data, prepanelFn = NULL, params = NULL, packages = NULL,
  control = NULL, verbose = TRUE)
}
\arguments{
\item{data}{an object of class "localDiv" or "rhData"}

\item{prepanelFn}{a prepanel function that returns a list specifying \code{xlim} and \code{ylim} for determining axis limits, and optionally \code{dx} and \code{dy} for determining aspect ratio (used to define slopes of line segments used for banking computations).  prepanelFn can also be a panelFn (see \code{\link{makeDisplay}}) that returns either an object of class "trellis" or "ggplot", since xlim and ylim can be determined from these.}

\item{params}{a named list of parameters external to the input data that are needed in the distributed computing (most should be taken care of automatically such that this is rarely necessary to specify)}

\item{packages}{a vector of R package names that contain functions used in \code{prepanelFn} (most should be taken care of automatically such that this is rarely necessary to specify)}

\item{control}{parameters specifying how the backend should handle things (most-likely parameters to \code{rhwatch} in RHIPE) - see \code{\link{rhipeControl}} and \code{\link{localDiskControl}}}

\item{verbose}{print status messages?}
}
\value{
object of class "trsPre".  This is a list of the x and y axis ranges for each split, along with the aspect ratio banking value if \code{dx} and \code{dy} are supplied in \code{prepanelFn}.  Can be used with \code{\link{plot.trsPre}} and \code{\link{setLims}}.
}
\description{
Apply a prepanel function to objects of class "ddo" or "ddf" to determine ranges of x and y axis limits prior to creating a trelliscope display (\code{\link{makeDisplay}}).  Useful in conjunction with \code{\link{setLims}}.
}
\details{
The plot method plots the sorted axis ranges for the x and y axis for the case of "same" (all axis limits share the same range) and "sliced" (all axis limits share the) and can be useful in helping determine how to ultimately set the limits.

You do not need to use \code{prepanel()} to ultimately create a display with \code{\link{makeDisplay}()}, but if you bypass, you will either need to specify your own limits in your plot command, or do nothing, in which case each individual plot will have limits based on the data in the split being plotted (the axes will be "free").

Axis limits are very important.  What makes viewing groups of plots of subsets of data ("small multiples") so powerful is being able to make meaningful visual comparisons across plots.  This is much easier to do if scales for each plot are commensurate.

This function is also useful for identifying subsets with very large outlying values, and in conjunction with \code{\link{setLims}}, allows you to account for that prior to the expensive process of creating all of the plots.
}
\examples{
d <- datadr::divide(iris, "Species")

irisPreFn <- function(x) {
  list(
    xlim = range(x$Sepal.Length),
    ylim = range(x$Sepal.Width)
  )
}

irisPre <- prepanel(d, prepanelFn = irisPreFn)

plot(irisPre)

irisLims <- setLims(irisPre, x = "same", y = "sliced")
}
\seealso{
\code{\link{x}}
\code{\link{plot.trsPre}}, \code{\link{setLims}}, \code{\link{makeDisplay}}
}

