% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psv.R
\name{psv}
\alias{psv}
\title{Phylogenetic Species Variability.}
\usage{
psv(phy, normalization = "none")
}
\arguments{
\item{phy}{phylo object or ltable}

\item{normalization}{"none" or "tips", in which case the obtained mean
pairwise distance is normalized by the factor 2log(n), where n is the number
of tips.}
}
\value{
Phylogenetic Species Variability
}
\description{
The phylogenetic species variability is bounded in [0, 1]. The
psv quantifies how phylogenetic relatedness decrease the variance of a
(neutral) trait shared by all species in the tree. As species become more
related, the psv tends to 0.
Please note that the psv is a special case of the Mean Pair Distance (see
appendix of Tucker et al. 2017 for a full derivation), and thus correlates
directly.
}
\references{
Helmus M.R., Bland T.J., Williams C.K. & Ives A.R. (2007)
Phylogenetic measures of biodiversity. American Naturalist, 169, E68-E83

Tucker, Caroline M., et al. "A guide to phylogenetic metrics for
conservation, community ecology and macroecology."
Biological Reviews 92.2 (2017): 698-715.
}
