% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma.R
\name{gamma_statistic}
\alias{gamma_statistic}
\title{Calculate the gamma statistic, using a fast implementation in C++.}
\usage{
gamma_statistic(phy)
}
\arguments{
\item{phy}{phylo object or ltable}
}
\value{
gamma statistic
}
\description{
The gamma statistic measures the relative position of
internal nodes within a reconstructed phylogeny. Under the Yule process,
the gamma values of a reconstructed tree follow a standard normal
distribution. If gamma > 0, the nodes are located more towards the tips of
the tree, and if gamma < 0, the nodes are located more towards the root of
the tree. Only available for ultrametric trees.
}
\examples{
simulated_tree <- ape::rphylo(n = 10, birth = 1, death = 0)
gamma_statistic(simulated_tree) # should be around 0.
if (requireNamespace("DDD")) {
  ddd_tree <- DDD::dd_sim(pars = c(1, 0, 10), age = 7)$tes
  gamma_statistic(ddd_tree) # because of diversity dependence, should be < 0
}
}
\references{
Pybus, O. G. and Harvey, P. H. (2000) Testing macro-evolutionary
models using incomplete molecular phylogenies. Proceedings of the Royal
Society of London. Series B. Biological Sciences, 267, 2267–2272.
}
