% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node-children}
\alias{node-children}
\alias{node_children}
\alias{node_named_children}
\title{Get a node's children}
\usage{
node_children(x)

node_named_children(x)
}
\arguments{
\item{x}{\verb{[tree_sitter_node]}

A node.}
}
\value{
The children of \code{x} as a list.
}
\description{
These functions return the children of \code{x} within a list.
\itemize{
\item \code{node_children()} considers both named and anonymous children.
\item \code{node_named_children()} considers only named children.
}
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "fn <- function() { 1 + 1 }"
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

# Navigate to first child
node <- node_child(node, 1)
node

# Note how the named variant doesn't include the anonymous operator node
node_children(node)
node_named_children(node)
\dontshow{\}) # examplesIf}
}
