% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node_parent}
\alias{node_parent}
\title{Get a node's parent}
\usage{
node_parent(x)
}
\arguments{
\item{x}{\verb{[tree_sitter_node]}

A node.}
}
\value{
The parent node of \code{x} or \code{NULL} if there is no parent.
}
\description{
\code{node_parent()} looks up the tree and returns the current node's parent.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "fn <- function() { 1 + 1 }"
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

# Parent of a root node is `NULL`
node_parent(node)

node_function <- node |>
  node_child(1) |>
  node_child(3)

node_function

node_parent(node_function)
\dontshow{\}) # examplesIf}
}
