% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distFunctions.R
\name{plotExtremeTrees}
\alias{plotExtremeTrees}
\title{Plot the min/max distance trees from a target tree}
\usage{
plotExtremeTrees(
  target,
  trees,
  n,
  comparison = "min",
  method = "logDiff",
  type = "real",
  numThreads = -1
)
}
\arguments{
\item{target}{the phylo object of the tree to calculate the distances to}

\item{trees}{a list of phylo objects to compare with the \strong{target}}

\item{n}{the number of trees to find and plot}

\item{comparison}{whether to find the \dQuote{min} or the \dQuote{max} distance trees from the \strong{target}}

\item{method}{method to use when calculating coefficient distances:
\describe{
  \item{\dQuote{logDiff}}{for two coefficient matrices A and B returns sum(log(1+abs(A-B))}
  \item{\dQuote{wLogDiff}}{performs the \dQuote{logDiff} method with weights on the rows}
  \item{\dQuote{pa}}{total pairs where the coefficient is present in one matrix and absent in the other (presence-absence)}
  \item{\dQuote{ap}}{opposite comparison of pa (absence-presence)}
}}

\item{type}{one of:
\describe{
  \item{\dQuote{real}}{real coefficient polynomials}
  \item{\dQuote{complex}}{complex coefficient polynomials (real polynomials with y = 1 + i)}
  \item{\dQuote{tipLabel}}{complex coefficient polynomial that utilize binary trait tip labels on the phylo objects}
}}

\item{numThreads}{number of threads to be used, the default (-1) will use the number of cores in the machine and numThreads = 0 will only use the main thread}
}
\value{
a list of lists containing the \strong{n} min/max distance trees and their distances to \strong{target}
}
\description{
Plot the min/max distance trees from a target tree
}
\note{
\itemize{
  \item the complex coefficient vector and the complex tip label coefficient matrix only support the \dQuote{logDiff} method
  \item \dQuote{pa} and \dQuote{ap} force symmetry in the output distance matrix
}
}
\examples{

library(treenomial)
library(ape)
trees <- c(rmtree(1000,50),rmtree(10,9))
target <- rtree(50)
minTrees <- plotExtremeTrees(target,trees,2, comparison = "min", numThreads = 0)

}
