% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_treemap.R
\name{geom_treemap}
\alias{geom_treemap}
\title{A 'ggplot2' geom to draw a treemap.}
\usage{
geom_treemap(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, fixed = FALSE, ...)
}
\arguments{
\item{mapping, data, stat, position, na.rm, show.legend, inherit.aes, ...}{Standard
geom arguments as for `ggplot2::geom_rect`.}

\item{fixed}{If `TRUE`, the alternative 'fixed' tile layout algorithm will be
used.}
}
\description{
A treemap is a rectangular plot divided into tiles, each of which represents
a single observation. The relative area of each tile expresses a continuous
variable.
}
\details{
`geom_treemap` requires an `area` aesthetic. It will ignore any aesthetics
relating to the x and y axes (e.g. `xmin` or `y`), as the x and y axes are
not meaningful in a treemap. Several other standard 'ggplot2' aesthetics are
supported (see Aesthetics). To add text labels to tiles, see
`geom_treemap_text`.

An optional `subgroup` aesthetic will cause the tiles to be clustered in
subgroups within the treemap. See `geom_treemap_subgroup_border` and
`geom_treemap_subgroup_text` to draw borders around subgroups and label
them, respectively. Up to three nested levels of subgrouping are supported,
with `subgroup2` and `subgroup3` aesthetics and respective
`geom_treemap_subgroup2_border` etc. geoms.

Two algorithms for the tile layout are provided. With the default
'squarified' algorithm (`fixed = FALSE`), the priority is ensuring the tiles
have an aesthetically pleasing aspect ratio; that is, they are not too narrow
or too short. In this algorithm, tile placement proceeds from the bottom left
corner, filling alternately rightwards then upwards until all tiles are
placed. See Bruls et al. (1999) for the full algorithm.

With the alternative 'fixed' layout algorithm (`fixed = TRUE`), the plot area
is divided into vertical columns, which are filled from left to right with an
equal number of tiles beginning at the bottom of each column. Unlike the
default 'squarified' algorithm, with the 'fixed' algorithm the relative
positions of the tiles are fixed by their order in the input data frame. This
can result in aesthetically unpleasing tiles, but it allows side-by-side
comparisons or animations to be created.

All `treemapify` geoms added to a plot should have the same value for
`fixed`, or they will not share a common layout.
}
\section{Aesthetics}{


\itemize{
  \item area (required)
  \item alpha
  \item colour
  \item fill
  \item linetype
  \item subgroup
  \item subgroup2
  \item subgroup3
}
}

\examples{

ggplot2::ggplot(G20, ggplot2::aes(area = gdp_mil_usd, fill = region)) +
 geom_treemap()

}
\references{
Bruls, M., Huizing, K., & van Wijk, J. (1999). Squarified Treemaps (pp.
33-42). Proceedings of the Joint Eurographics and IEEE TCVG Symposium on
Visualization. \url{http://www.win.tue.nl/~vanwijk/stm.pdf}
}
\seealso{
geom_treemap_text, geom_treemap_subgroup_border,
geom_treemap_subgroup_text
}
