% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/treegraph.R
\name{treegraph}
\alias{treegraph}
\title{Create a tree graph}
\usage{
treegraph(dtf, index = names(dtf), directed = FALSE, palette.HCL.options,
  show.labels = FALSE, rootlabel = "", vertex.layout = "reingold.tilford",
  vertex.layout.params, truncate.labels = NULL, vertex.size = 3,
  vertex.label.dist = 0.3, vertex.label.cex = 0.8,
  vertex.label.family = "sans", vertex.label.color = "black", mai = c(0,
  0, 0, 0), ...)
}
\arguments{
\item{dtf}{a data.frame or data.table. Required.}

\item{index}{the index variables of dtf (see \code{\link{treemap}})}

\item{directed}{logical that determines whether the graph is directed (\code{TRUE}) or undirected (\code{FALSE})}

\item{palette.HCL.options}{list of advanced options to obtain Tree Colors from  the HCL space (when \code{palette="HCL"}). This list contains:
\describe{
       \item{\code{hue_start}:}{number between 0 and 360 that determines the starting hue value (default: 30)}
       \item{\code{hue_end}:}{number between \code{hue_start} and \code{hue_start + 360} that determines the ending hue value (default: 390)}
       \item{\code{hue_perm}:}{boolean that determines whether the colors are permuted such that adjacent levels get more distinguishable colors. If \code{FALSE}, then the colors are equally distributed from \code{hue_start} to \code{hue_end} (default: TRUE)}
       \item{\code{hue_rev}:}{boolean that determines whether the colors of even-numbered branched are reversed (to increase discrimination among branches)}
       \item{\code{hue_fraction}:}{number between 0 and 1 that determines the fraction of the hue circle that is used for recursive color picking: if 1 then the full hue circle is used, which means that the hue of the colors of lower-level nodes are spread maximally. If 0, then the hue of the colors of lower-level nodes are identical of the hue of their parents. (default: .5)}
       \item{\code{chroma}:}{chroma value of colors of the first-level nodes, that are determined by the first index variable (default: 60)}
       \item{\code{luminance}:}{luminance value of colors of the first-level nodes, i.e. determined by the first index variable (default: 70)}
       \item{\code{chroma_slope}:}{slope value for chroma of the non-first-level nodes. The chroma values for the second-level nodes are \code{chroma+chroma_slope}, for the third-level nodes \code{chroma+2*chroma_slope}, etc. (default: 5)}
       \item{\code{luminance_slope}:}{slope value for luminance of the non-first-level nodes (default: -10)}} For "depth" and "categorical" types, only the first two items are used. Use \code{\link{treecolors}} to experiment with these parameters.}

\item{show.labels}{show the labels}

\item{rootlabel}{name of the rootlabel}

\item{vertex.layout}{layout algorithm name. See \code{\link[igraph:layout]{layout}} for options. The name corresponds to the layout function name after the period symbol, e.g. "auto", "random", etc. The default is "reingold.tilford" with a cirular layout.}

\item{vertex.layout.params}{list of arguments passed to \code{vertex.layout}}

\item{truncate.labels}{number of characters at which the levels are truncated. Either a single value for all index variables, or a vector of values for each index variable}

\item{vertex.size}{vertex.size (see \code{\link[igraph:igraph.plotting]{igraph.plotting}})}

\item{vertex.label.dist}{vertex.label.dist (see \code{\link[igraph:igraph.plotting]{igraph.plotting}})}

\item{vertex.label.cex}{vertex.label.cex (see \code{\link[igraph:igraph.plotting]{igraph.plotting}})}

\item{vertex.label.family}{vertex.label.family (see \code{\link[igraph:igraph.plotting]{igraph.plotting}})}

\item{vertex.label.color}{vertex.label.color (see \code{\link[igraph:igraph.plotting]{igraph.plotting}})}

\item{mai}{margins see \code{\link[graphics:par]{par}}}

\item{...}{arguments passed to \code{\link[igraph:plot.igraph]{plot.igraph}}}
}
\value{
(invisible) igraph object
}
\description{
This function draws a tree graph. By default, a radial layout is used.
}
\examples{
data(business)
treegraph(business, index=c("NACE1", "NACE2", "NACE3", "NACE4"), show.labels=FALSE)
treegraph(business[business$NACE1=="F - Construction",],
    index=c("NACE2", "NACE3", "NACE4"), show.labels=TRUE, truncate.labels=c(2,4,6))
treegraph(business[business$NACE1=="F - Construction",],
    index=c("NACE2", "NACE3", "NACE4"), show.labels=TRUE, truncate.labels=c(2,4,6),
    vertex.layout="fruchterman.reingold")
}

