% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-methods.R
\name{setTxnyms}
\alias{setTxnyms}
\title{Set the txnym slots in a tree}
\usage{
setTxnyms(tree, txnyms)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{txnyms}{named vector or list}
}
\description{
Return a tree with txnyms added to specified nodes
}
\details{
Returns a tree. Specify the taxonomic groups for nodes in a tree
by providing a vector or list named by node IDs. Takes output from \code{searchTxnyms}.
Only letters, numbers and underscores allowed. To remove special characters use regular
expressions, e.g. \code{gsub(['a-zA-Z0-9_'], '', txnym)}
}
\examples{
library(treeman)
data(mammals)
# let's change the txnym for humans
# what's its summary before we change anything?
summary(mammals[['Homo_sapiens']])
# now let's add Hominini
new_txnym <- list('Homo_sapiens'=c('Hominini', 'Homo'))
mammals <- setTxnyms(mammals, new_txnym)
summary(mammals[['Homo_sapiens']])
}
\seealso{
\code{\link{taxaResolve}}, \code{\link{searchTxnyms}},
\code{\link{getNdsLng}}, \code{\link{getNdLng}},
\url{https://github.com/DomBennett/treeman/wiki/set-methods}
}
