% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-methods.R
\name{calcPhyDv}
\alias{calcPhyDv}
\title{Calculate phylogenetic diversity}
\usage{
calcPhyDv(tree, tids, parallel = FALSE, progress = "none")
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{tids}{tip ids}

\item{parallel}{logical, make parallel?}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Returns the phylogenetic diversity of a tree for the tips specified.
}
\details{
Faith's phylogenetic diversity is calculated as the sum of all connected
branches for specified tips in a tree. It can be used to investigate how biodviersity
as measured by the phylogeny changes. Parallelizable.
The function uses \code{getCnntdNds()}.
}
\examples{
library(treeman)
tree <- randTree(10)
calcPhyDv(tree, tree['tips'])
}
\references{
Faith, D. (1992). Conservation evaluation and phylogenetic diversity.
 Biological Conservation, 61, 1-10.
}
\seealso{
\code{\link{calcFrPrp}}, \code{\link{calcOvrlp}}, \code{\link{getCnnctdNds}},
\url{https://github.com/DomBennett/treeman/wiki/calc-methods}
}
