% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-write-methods.R
\name{writeTree}
\alias{writeTree}
\title{Write a Newick tree}
\usage{
writeTree(
  tree,
  file,
  append = FALSE,
  ndLabels = function(nd) {     return(NULL) },
  parallel = FALSE,
  progress = "none"
)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{file}{file path}

\item{append}{T/F append tree to already existing file}

\item{ndLabels}{node label function}

\item{parallel}{logical, make parallel?}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Creates a Newick tree from a \code{TreeMan} object.
}
\details{
The \code{ndLabels} argument can be used to add a user defined node label in
the Newick tree. It should take only 1 argument, \code{nd}, the node represented as a list.
It should only return a single character value that can be added to a newick string.
}
\examples{
library(treeman)
tree <- randTree(10)
# write out the tree with node labels as IDs
ndLabels <- function(n) {
n[['id']]
}
writeTree(tree, file='example.tre', ndLabels=ndLabels)
file.remove('example.tre')
}
\seealso{
\url{https://en.wikipedia.org/wiki/Newick_format},
\code{\link{readTree}}, \code{\link{randTree}},
\code{\link{readTrmn}}, \code{\link{writeTrmn}},
\code{\link{saveTreeMan}}, \code{\link{loadTreeMan}}
}
