% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeman-declaration.R, R/treemen-declaration.R
\docType{class}
\name{TreeMan-class}
\alias{TreeMan-class}
\alias{TreeMan-method}
\alias{[[,TreeMan,character-method}
\alias{[,TreeMan,character,missing,missing-method}
\alias{as.character,TreeMan-method}
\alias{show,TreeMan-method}
\alias{print,TreeMan-method}
\alias{str,TreeMan-method}
\alias{summary,TreeMan-method}
\alias{cTrees,TreeMan-method}
\title{TreeMan-class}
\usage{
\S4method{[[}{TreeMan,character}(x, i)

\S4method{[}{TreeMan,character,missing,missing}(x, i, j, ..., drop = TRUE)

\S4method{as.character}{TreeMan}(x)

\S4method{show}{TreeMan}(object)

\S4method{print}{TreeMan}(x)

\S4method{str}{TreeMan}(object, max.level = 2L, ...)

\S4method{summary}{TreeMan}(object)

\S4method{cTrees}{TreeMan}(x, ...)
}
\arguments{
\item{x}{\code{TreeMan} object}

\item{i}{node ID or slot name}

\item{j}{missing}

\item{...}{additional tree objects}

\item{drop}{missing}

\item{object}{\code{TreeMan} object}

\item{max.level}{\code{str()} maximum number of levels to show}
}
\description{
S4 class for representing phylogenetic trees as a list of nodes.
}
\details{
A \code{TreeMan} object holds a list of nodes. The idea of the \code{TreeMan}
class is to make adding and removing nodes as similar as possible to adding
and removing elements in a list. Note that internal nodes and tips are
both considered nodes. Trees can be polytomous but not unrooted.


Each node within the \code{TreeMan} \code{ndlst} contains the following data slots:
\itemize{
   \item \code{id}: character string for the node ID
   \item \code{txnym}: name of taxonomic clade (optional)
   \item \code{spn}: length of the preceding branch
   \item \code{prid}: ID of the immediately preceding node, NULL if root
   \item \code{ptid}: IDs of the immediately connecting nodes
}

See below in 'Examples' for these methods in use.
}
\section{Slots}{

\describe{
\item{\code{ndlst}}{list of nodes}

\item{\code{nds}}{vector of node ids that are internal nodes}

\item{\code{nnds}}{numeric of number of internal nodes in tree}

\item{\code{tips}}{vector of node ids that are tips}

\item{\code{ntips}}{numeric of number of internal nodes in tree}

\item{\code{all}}{vector of all node ids}

\item{\code{nall}}{numeric of number of all nodes in tree}

\item{\code{pd}}{numeric of total branch length of tree}

\item{\code{tinds}}{indexes of all tip nodes in tree}

\item{\code{prinds}}{indexes of all pre-nodes in tree}

\item{\code{wspn}}{logical, do nodes have spans}

\item{\code{wtxnyms}}{logical, do nodes have txnyms}

\item{\code{ply}}{logical, is tree bifurcating}

\item{\code{root}}{character of node id of root, if no root then empty character}

\item{\code{updtd}}{logical, if tree slots have been updated since initiation or change}

\item{\code{othr_slt_nms}}{vector, character list of additional data slots added to nodes}

\item{\code{ndmtrx}}{matrix, T/Fs representing tree structure}
}}

\examples{
library(treeman)
# Generate random tree
tree <- randTree(10)
# Print to get basic stats
summary(tree)
# Slots....
tree['tips']   # return all tips IDs
tree['nds']    # return all internal node IDs
tree['ntips']  # count all tips
tree['nnds']   # count all internal nodes
tree['root']   # identify root node
tree[['t1']]   # return t1 node object
tree['pd']     # return phylogenetic diversity
tree['ply']    # is polytomous?
# Additional special slots (calculated upon call)
tree['age']   # get tree's age
tree['ultr']  # determine if tree is ultrametric
tree['spns']  # get all the spans of the tree IDs
tree['prids'] # get all the IDs of preceding nodes
tree['ptids'] # get all the IDs of following nodes
tree['txnyms'] # get all the taxonyms of all nodes
# In addition [] can be used for any user-defined slot
# Because all nodes are lists with metadata we can readily
#  get specific information on nodes of interest
nd <- tree[['n2']]
summary(nd)
# And then use the same syntax for the tree
nd['nkids']  # .... nkids, pd, etc.

# Convert to phylo and plot
library(ape)
tree <- as(tree, 'phylo')
plot(tree)
}
\seealso{
\code{\link{randTree}}, \code{\link{Node-class}},
\code{\link{phylo-to-TreeMan}}, \code{\link{TreeMan-to-phylo}}
}
