% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-methods.R
\name{calcNdsBlnc}
\alias{calcNdsBlnc}
\title{Calculate the balances of all nodes}
\usage{
calcNdsBlnc(tree, ids, parallel = FALSE, progress = "none")
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{ids}{node ids}

\item{parallel}{logical, make parallel?}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Returns the absolute differences in number of descendants for bifurcating 
branches of every node
}
\details{
Runs \code{calcNdBlnc()} across all node IDs. \code{NA} is returned if the
node is polytomous. Parallelizable.
}
\examples{
library(treeman)
tree <- randTree(10)
calcNdsBlnc(tree, ids=tree['nds'])
}
\seealso{
\code{\link{calcNdBlnc}}, 
\url{https://github.com/DomBennett/treeman/wiki/calc-methods}
}
