% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-write-methods.R
\name{saveTreeMan}
\alias{saveTreeMan}
\title{Save a TreeMan object in serialization format}
\usage{
saveTreeMan(tree, file)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{file}{file path}
}
\description{
\code{TreeMan} equivalent to \code{save()} but able to handle
node matrices.
}
\details{
It is not possible to use \code{save()} on \code{TreeMan} objects
with node matrices. Node matrices are bigmemory matrices and are therefore outside
the R environment, see bigmemory documentation for more information. Saving and loading
a bigmemory matrix may cause memory issues in R and cause R to crash.

This function can safely store a \code{TreeMan} object with and without
a node matrix. This function stores the tree using the serialization format and the node
matrix as a hidden .csv. Both parts of the tree can be reloaded to an R environment
with \code{loadTreeMan()}. The hidden node matrix filename is based on the file argument:
\code{file + _ndmtrx}

Reading and writing trees with \code{saveTreeMan()} and
\code{loadTreeMan} is faster than any of the other read and write functions.
}
\examples{
library(treeman)
tree <- randTree(100, wndmtrx=TRUE)
saveTreeMan(tree, file='test.RData')
rm(tree)
tree <- loadTreeMan(file='test.RData')
file.remove('test.RData', 'testRData_ndmtrx')
}
\seealso{
\code{\link{loadTreeMan}},
\code{\link{readTree}},\code{\link{writeTree}},
\code{\link{readTrmn}}, \code{\link{writeTrmn}}
}
