% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip-methods.R
\name{rmTip}
\alias{rmTip}
\title{Remove tip from a tree}
\usage{
rmTip(tree, tid, drp_intrnl = TRUE)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{tid}{tip ID}

\item{drp_intrnl}{Boolean, drop internal branches, default FALSE}
}
\description{
Returns a tree with a tip ID remove
}
\details{
Removes a tip in a tree. Set drp_intrnl to FALSE to convert
internal nodes into new tips.
}
\examples{
library(treeman)
tree <- randTree(10)
tree <- rmTip(tree, 't1')
}
\seealso{
\code{\link{addTip}}, 
\url{https://github.com/DomBennett/treeman/wiki/manip-methods}
}

