% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-methods.R
\name{getNdsPrid}
\alias{getNdsPrid}
\title{Get pre-nodes to root for multiple nodes}
\usage{
getNdsPrid(tree, ids, ...)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{ids}{vector of node ids}

\item{...}{\code{plyr} arguments}
}
\description{
Return node ids for connecting \code{ids} to root.
}
\details{
Returns a list, parallizable.
}
\examples{
library(treeman)
tree <- randTree(10)
# get all nodes to root
getNdsPrid(tree, ids=tree['tips'])
}
\seealso{
\code{\link{getNdPrid}}, 
\code{\link{getNdPtid}}, 
\code{\link{getNdsPtid}}, 
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}

