% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-methods.R
\name{getNdAge}
\alias{getNdAge}
\title{Get age}
\usage{
getNdAge(tree, id)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{id}{node id}
}
\description{
Return the root to tip distance for \code{id}.
}
\details{
Returns a numeric.
}
\examples{
library(treeman)
data(mammals)
# when did apes emerge?
# get parent id for all apes
prnt_id <- getPrnt(mammals, ids=c('Homo_sapiens', 'Hylobates_concolor'))
getNdAge(mammals, id=prnt_id)
}
\seealso{
\code{\link{getNdsAge}}, 
\code{\link{getSpnAge}}, 
\code{\link{getSpnsAge}}, 
\code{\link{getPrnt}}, 
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}

