% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_heat.R
\name{get_disp_feats}
\alias{get_disp_feats}
\title{Select the important features to be displayed.}
\usage{
get_disp_feats(fit, feat_names, show_all_feats, custom_tree, p_thres)
}
\arguments{
\item{fit}{constparty object of the decision tree.}

\item{feat_names}{Character vector specifying the feature names in dat.}

\item{show_all_feats}{Logical. If TRUE, show all features regarless p_thres.}

\item{custom_tree}{Custom tree with the partykit syntax.
https://cran.r-project.org/web/packages/partykit/vignettes/partykit.pdf
If NULL, a conditional inference tree is computed.}

\item{p_thres}{Numeric value indicating the p-value threshold of feature importance.
Feature with p-values computed from the decision tree below this value
will be displayed on the heatmap.}
}
\value{
A character vector of feature names.
}
\description{
Select features with p-value (computed from decision tree) < `p_thres`
or all features if `show_all_feats == TRUE`.
}
