% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomass.R
\name{treeBiomass}
\alias{treeBiomass}
\title{Computes masses of branches and logs}
\usage{
treeBiomass(object)
}
\arguments{
\item{object}{an object of \code{treeData} class}
}
\value{
an object of \code{treeData} class
}
\description{
Computes branches biomass using an allometric function provided in \code{object$allometryFUN} and logs weight using Smalian's formula.

Branches are telled apart from logs in the raw data frame (\code{object$fieldData}) because their final diameter is 0 (ie they have a tip) whereas logs have a final diameter > 0.
}
\seealso{
\code{\link{logBiomass}}

Other Biomass: \code{\link{allometryABDC}},
  \code{\link{allometryAsca2011}},
  \code{\link{allometryCutini2009}},
  \code{\link{allometryPorte2002}},
  \code{\link{logBiomass}}, \code{\link{powerEquation}},
  \code{\link{pureQuadraticEquation}},
  \code{\link{treeTotalBiomass}}
}

