% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw2bwi2022de.R
\name{select_valid_angle_count_trees}
\alias{select_valid_angle_count_trees}
\title{Select Valid Angle Counts Only}
\usage{
select_valid_angle_count_trees(x, sample_type = "stp", tree_status = "pk")
}
\arguments{
\item{x}{A tree data set, typically
\code{get(data(trees, package = "treePlotArea"))}.}

\item{sample_type}{An indicator giving the type of sample the tree was
in. 0 marks the angle count sample with counting factor 4.}

\item{tree_status}{An indicator giving the status of a tree in the German
national forest inventory. 0 marks ingrowth, 1 marks ongrowth.}
}
\value{
A tree data containing valid angle count trees only.
}
\description{
The tree data coming with this package was processed by Gerald Kaendler for
the
country of  Baden-Wuerttemberg, and is the reference for testing as he
adjusted diameter measurements to breast height where they had been measured
in diverging heights (due to deformations of trees at breast height).
Which we really need to do.
But he also
added trees that are not part of the angle count sampling, which this
function removes. We need that mainly to run tests against the reference
values computed by \command{grenzkreis} because we would not be able to
easily find the keys to merge the data. \emph{So this function is probably of
no use to you.}
And we remove trees with a diameter at breast height greater than zero and a
distance of 0, for these tree should not be there.
}
\examples{
trees <- get(data("trees", package = "treePlotArea"))
subset(trees, entf == 0 & bhd2 > 0 & stp == 0)
angle_counts <- select_valid_angle_count_trees(trees)
subset(angle_counts, entf == 0 & bhd2 > 0 & stp == 0)
}
\seealso{
Other data functions: 
\code{\link{bw2bwi2022de}()}
}
\concept{data functions}
