% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwi2cartesian.R
\name{bwi2cartesian}
\alias{bwi2cartesian}
\title{Convert Coordinates of the German National Forest Inventory to Cartesian
Coordinates}
\usage{
bwi2cartesian(azimuth, distance)
}
\arguments{
\item{azimuth}{The azimuths, from north, eastern side, in gon.}

\item{distance}{The distances from the origin, typically measured in
centimeter.}
}
\value{
Matrix of cartesian coordinates in the unit of \code{distance}.
}
\description{
Coordinates of the German national forest inventory are measured in gon
eastward from north at distance in centimeter.
We need cartesian coordinates for relational computations.
}
\examples{
a1 <- c(0, 100)
d1 <- c(100, 200)
print(coords <- bwi2cartesian(a1, d1))
all.equal(coords, matrix(c(0, 100, 200, 0), nrow = 2, byrow = TRUE),
          check.attributes = FALSE)
}
\keyword{internal}
