% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssVarstocases.R
\name{xpssVarsToCases}
\alias{xpssVarsToCases}
\title{Transforms variables to cases}
\usage{
xpssVarsToCases(x, from, idVar = NULL, indexVar = NULL, nullArg = "keep",
countVar = NULL, varLabels = list(id = NULL, index = NULL, count = NULL))
}
\arguments{
\item{x}{as a (non-empty) data.frame or input data of class "xpssFrame".}

\item{from}{variable that opens the span.}

\item{idVar}{determines whether an id-variable should be created.}

\item{indexVar}{determines whether an index-variable should be created.}

\item{nullArg}{Can be either "keep" or "drop".}

\item{countVar}{determines whether a counter should be created?}

\item{varLabels}{determines whether labels for id-, index- and count variables are set.}
}
\value{
Returns the transformed xpssFrame.
}
\description{
Creates a transfromed xpssFrame.
}
\examples{
data(fromXPSS)

xpssVarsToCases(fromXPSS, from = list(c("newVar", "V7_1, V7_2")),
idVar = "myID", indexVar = "myIndex", nullArg = "drop", countVar = "Counter")
}
\author{
Andreas Wygrabek
}

