% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tramTMB.R
\name{tramTMB}
\alias{tramTMB}
\title{Create a tramTMB object}
\usage{
tramTMB(
  data,
  parameters,
  constraint,
  negative,
  map = list(),
  resid = FALSE,
  do_update = FALSE,
  check_const = TRUE,
  no_int = FALSE,
  ...
)
}
\arguments{
\item{data}{List of data objects (vectors, matrices, arrays, factors, sparse matrices) required by the user template (order does not matter and un-used components are allowed).}

\item{parameters}{List of all parameter objects required by the user template (both random and fixed effects).}

\item{constraint}{list describing the constarints on the parameters}

\item{negative}{logical, whether the model is parameterized with negative values}

\item{map}{same as map argument of \code{TMB::MakeADFun}}

\item{resid}{logical, indicating whether the score residuals are calculated
from the resulting object}

\item{do_update}{logical, indicating whether the model should be set up with
updateable offsets and weights}

\item{check_const}{Logical; if \code{TRUE} check the parameter constraints before
evaluating the returned functions.}

\item{no_int}{Logical; if \code{FALSE} skip the numerical integration step.}

\item{...}{optional parameters passed to \code{TMB::MakeADFun}}
}
\value{
A tramTMB object.
}
\description{
Create a tramTMB object
}
\note{
The post-estimation parameters are supplied as a part of \code{data}
}
