% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{parboot.tramME}
\alias{parboot.tramME}
\title{Do parametric bootsrap using a tarmME model}
\usage{
\method{parboot}{tramME}(
  object,
  statistic,
  nsim = 1,
  conditional = FALSE,
  seed = NULL,
  ...,
  simplify = TRUE,
  parallel = c("no", "multicore", "snow"),
  ncpus = getOption("profile.ncpus", 1L)
)
}
\arguments{
\item{object}{A \code{tramME} object.}

\item{statistic}{A function that calculates the statistic of interest.}

\item{nsim}{Number of draws.}

\item{conditional}{Logical, if \code{TRUE}, the resampling is conditional on the
fitted vector of random effects.}

\item{seed}{optional seed for the random number generator}

\item{...}{Optional arguments passed to \code{statistic}.}

\item{simplify}{logical or character string; should the result be
    simplified to a vector, matrix or higher dimensional array if
    possible?  For \code{sapply} it must be named and not abbreviated.
    The default value, \code{TRUE}, returns a vector or matrix if appropriate,
    whereas if \code{simplify = "array"} the result may be an
    \code{\link[base]{array}} of \dQuote{rank}
    (\eqn{=}\code{length(dim(.))}) one higher than the result
    of \code{FUN(X[[i]])}.}

\item{parallel}{Method for parallel computation.}

\item{ncpus}{Number of cores to use for parallel computation.}
}
\value{
A list/vector/array (whichever is consistent with \code{simplify}) of bootstrapped
  values returned by \code{statistic}.
}
\description{
Do parametric bootsrap using a tarmME model
}
