% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trafo.R
\name{plot.trafo.tramME}
\alias{plot.trafo.tramME}
\title{Plotting method for \code{trafo.tramME} objects}
\usage{
\method{plot}{trafo.tramME}(x, col = 1, fill = "lightgrey", lty = 1, add = FALSE, ...)
}
\arguments{
\item{x}{A \code{trafo.tramME} object.}

\item{col}{Line colors, recycled if shorter than the size of the
\code{trafo.tramME} object.}

\item{fill}{Fill color for the confidence intervals.}

\item{lty}{Line types.}

\item{add}{If \code{TRUE} add to an existing plot.}

\item{...}{Additional arguments, passed to \code{plot} or \code{lines}.}
}
\value{
The original \code{trafo.tramME} object, invisibly.
}
\description{
Plotting method for \code{trafo.tramME} objects
}
\examples{
data("sleepstudy", package = "lme4")
fit <- BoxCoxME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
tr <- trafo(fit, type = "trafo", confidence = "interval", K = 100)
plot(tr, col = 2, main = "Trafo")
}
