% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajmsm_ipw.R
\name{trajmsm_ipw}
\alias{trajmsm_ipw}
\title{Marginal Structural Model and Latent Class of Growth Analysis estimated with IPW}
\usage{
trajmsm_ipw(
  formula1,
  formula2,
  family,
  identifier,
  treatment,
  covariates,
  baseline,
  obsdata,
  numerator = "stabilized",
  include_censor = FALSE,
  censor,
  weights = NULL,
  treshold = 0.99
)
}
\arguments{
\item{formula1}{Specification of the model for the outcome to be fitted for a binomial or gaussian distribution.}

\item{formula2}{Specification of the model for the outcome to be fitted for a survival outcome.}

\item{family}{Specification of the error distribution and link function to be used in the model.}

\item{identifier}{Name of the column of the unique identifier.}

\item{treatment}{Time-varying treatment.}

\item{covariates}{Names of the time-varying covariates (should be a list).}

\item{baseline}{Name of the baseline covariates.}

\item{obsdata}{Dataset to be used in the analysis.}

\item{numerator}{Type of weighting ("stabilized" or "unstabilized").}

\item{include_censor}{Logical, if TRUE, includes censoring.}

\item{censor}{Name of the censoring variable.}

\item{weights}{A vector of estimated weights. If NULL, the weights are computed by the function \code{IPW}.}

\item{treshold}{For weight truncation.}
}
\value{
Provides a matrix of estimates for LCGA-MSM, obtained using IPW.

Provides a matrix of estimates for LCGA-MSM, obtained using IPW.
}
\description{
Estimate parameters of LCGA-MSM using IPW.
}
\examples{
obsdata_long = gendata(n = 1000, format = "long", total_followup = 6, seed = 845)
years <- 2011:2016
baseline_var <- c("age","sex")
variables <- c("hyper", "bmi")
covariates <- lapply(years, function(year) {
paste0(variables, year)})
treatment_var <- paste0("statins", 2011:2016)
formula_treatment = as.formula(cbind(statins, 1 - statins) ~ time)
restraj = build_traj(obsdata = obsdata_long, number_traj = 3,
formula = formula_treatment, identifier = "id")
datapost = restraj$data_post
trajmsm_long <- merge(obsdata_long, datapost, by = "id")
    AggFormula <- as.formula(paste("statins", "~", "time", "+", "class"))
    AggTrajData <- aggregate(AggFormula, data = trajmsm_long, FUN = mean)
    AggTrajData
trajmsm_long$ipw_group <- relevel(trajmsm_long$class, ref = "1")
obsdata = reshape(data = trajmsm_long, direction = "wide", idvar = "id",
v.names = c("statins","bmi","hyper"), timevar = "time", sep ="")
formula = paste0("y ~", paste0(treatment_var,collapse = "+"), "+",
                paste0(unlist(covariates), collapse = "+"),"+",
                paste0(baseline_var, collapse = "+"))

resmsm_ipw = trajmsm_ipw(formula1 = as.formula("y ~ ipw_group"),
           identifier = "id", baseline = baseline_var, covariates = covariates,
           treatment = treatment_var, family = "binomial",
           obsdata = obsdata,numerator = "stabilized", include_censor = FALSE, treshold = 0.99)
resmsm_ipw
}
