% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_traj.R
\name{build_traj}
\alias{build_traj}
\title{Wrapper for flexmix}
\usage{
build_traj(
  obsdata,
  formula,
  number_traj,
  identifier,
  family = "binomial",
  seed = 945,
  control = list(iter.max = 1000, minprior = 0),
  ...
)
}
\arguments{
\item{obsdata}{Data to build trajectory groups in long format.}

\item{formula}{Designate the formula to model the longitudinal variable of interest.}

\item{number_traj}{An integer to fix the number of trajectory groups.}

\item{identifier}{A string to designate the column name for the unique identifier.}

\item{family}{Designate the type of distribution ("gaussian", "binomial", "poisson", "gamma").}

\item{seed}{Set a seed for replicability.}

\item{control}{Object of class FLXcontrol.}

\item{...}{Additional arguments passed to the flexmix function.}
}
\value{
A list containing the posterior probability matrix and the fitted trajectory model.
}
\description{
Call the package flexmix to build trajectory groups
}
\examples{
obsdata_long = gendata(n = 1000,format = "long", total_followup = 6, seed = 945)
formula = as.formula(cbind(statins, 1 - statins) ~ time)
restraj = build_traj(obsdata = obsdata_long, number_traj = 3, formula = formula, identifier = "id")
}
