% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{track_}
\alias{track_}
\alias{track}
\alias{track_tbl}
\alias{track_dt}
\alias{track_df}
\title{Build a Track Table}
\usage{
track(x, y, z, t, id, ..., proj, origin, period, tz, format, table = "df")

track_df(x, y, z, t, id, ..., proj, origin, period, tz, format)

track_tbl(x, y, z, t, id, ..., proj, origin, period, tz, format)

track_dt(x, y, z, t, id, ..., proj, origin, period, tz, format)
}
\arguments{
\item{x, y, z}{Numeric vectors representing the coordinates of the locations.
\code{x} and \code{y} are required. \code{z} can be ignored if the
trajectories are 2-dimensional. Note: if the vectors are not of the same
length, the shorter ones will be recycled to match the length of the longer
one.}

\item{t}{A numeric vector or a vector of objects that can be coerced to
date-time objects by \code{\link[lubridate]{as_datetime}} representing the
times (or frames) at which each location was recorded. If numeric, the
origin and period of the time points can be set using \code{origin} and
\code{period} below.}

\item{id}{A vector that can be coerced to a character vector by
\code{\link{as.character}} representing the identity of the animal to which
each location belong.}

\item{...}{A set of name-value pairs. Arguments are evaluated sequentially,
so you can refer to previously created elements. These arguments are
processed with \code{\link[rlang:quotation]{rlang::quos()}} and support
unquote via \code{!!} and unquote-splice via \code{!!!}. Use \code{:=} to
create columns that start with a dot.}

\item{proj}{A character string or a \code{\link[terra:crs]{terra::crs}}
object representing the projection of the coordinates. Leave empty if the
coordinates are not projected (e.g., output of video tracking).
\code{"+proj=longlat"} is suitable for the output of most GPS trackers.}

\item{origin}{Something that can be coerced to a date-time object by
\code{\link[lubridate]{as_datetime}} representing the start date and time of
the observations when \code{t} is a numeric vector.}

\item{period}{A character vector in a shorthand format (e.g. "1 second") or
ISO 8601 specification. This is used when \code{t} is a numeric vector to
represent time unit of the observations. All unambiguous name units and
abbreviations are supported, "m" stands for months, "M" for minutes unless
ISO 8601 "P" modifier is present (see examples). Fractional units are
supported but the fractional part is always converted to seconds. See
\code{\link[lubridate]{period}} for more details.}

\item{tz}{A time zone name. See \code{\link{OlsonNames}}.}

\item{format}{A character string indicating the formatting of `t`. See
 \code{\link{strptime}} for how to specify this parameter.

When supplied parsing is performed by strptime(). For this reason consider using specialized parsing functions in lubridate.}

\item{table}{A string indicating the class of the table on which the track
table should be built. It can be a \code{\link{data.frame}} ("df", the default),
a \code{\link[tibble]{tibble}} ("tbl"), or a \code{\link[data.table]{data.table}}
("dt").}
}
\value{
A track table, which is a colloquial term for an object of class
 \code{track}.
}
\description{
\code{track} constructs track tables based on \code{\link{data.frame}}
 (the default), \code{\link[tibble]{tibble}}, or \code{\link[data.table]{data.table}}.
 \code{track} is a convenience function that executes \code{track_df},
 \code{track_tbl}, or \code{track_dt} based on the value of the `table`
 parameter. Track tables can be used like the data structure they are build
 upon but with a notable difference: they have an extra attribute to store
 the projection of the track coordinates, and modifying the projection will
 automatically trigger the appropriate conversion of the coordinates.
}
\examples{
data(short_tracks)

t_df <- track(x = short_tracks$x, y = short_tracks$y, t = short_tracks$t,
  id = short_tracks$id, proj = "+proj=longlat", tz = "Africa/Windhoek", table = "df")

t_df <- track_df(x = short_tracks$x, y = short_tracks$y, t = short_tracks$t,
  id = short_tracks$id, proj = "+proj=longlat", tz = "Africa/Windhoek")

t_tbl <- track_tbl(x = short_tracks$x, y = short_tracks$y, t = short_tracks$t,
id = short_tracks$id, proj = "+proj=longlat", tz = "Africa/Windhoek")

t_dt <- track_dt(x = short_tracks$x, y = short_tracks$y, t = short_tracks$t,
  id = short_tracks$id, proj = "+proj=longlat", tz = "Africa/Windhoek")

}
\author{
Simon Garnier, \email{garnier@njit.edu}
}
