% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\name{duplicated_t}
\alias{duplicated_t}
\title{Find Duplicated Timestamps in a Track Table}
\usage{
duplicated_t(x)
}
\arguments{
\item{x}{\code{\link{track}} table as produced by the \code{\link{track}}
function.}
}
\value{
A data frame/table/tibble with the duplicated timestamps for each
 individual track in \code{x}. If no duplicated data are detected, the
 function returns \code{NULL}.
}
\description{
This function attempts to automatically detect duplicated
 timestamps in \code{\link{track}} tables.
}
\note{
Incomplete data (that is, data containing "NAs") are ignored.
}
\examples{
# Create data set with duplicated data
data(short_tracks)
t_df <- track(x = short_tracks$x, y = short_tracks$y, t = short_tracks$t,
              id = short_tracks$id, proj = "+proj=longlat",
              tz = "Africa/Windhoek", table = "df")
t_df <- bind_tracks(t_df, t_df[1:10, ], t_df[100:110, ])

# Find duplicated timestamps
duplicated <- duplicated_t(t_df)

}
\seealso{
\code{\link{track}}
}
\author{
Simon Garnier, \email{garnier@njit.edu}
}
