% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{[.track}
\alias{[.track}
\alias{[<-.track}
\title{Extract or Replace Parts of a Track Table}
\usage{
\method{[}{track}(x, ...)

\method{[}{track}(x, ...) <- value
}
\arguments{
\item{x}{A track table.}

\item{...}{Other parameters to be passed to the extracting/subsetting
functions of \code{\link{data.frame}}, \code{\link[tibble]{tibble}}, and
\code{\link[data.table]{data.table}}.}

\item{value}{A suitable replacement value: it will be repeated a whole number
of times if necessary and it may be coerced: see the `Coercion` section in
\code{\link{data.frame}}. If `NULL`, deletes the column if a single column
is selected.}
}
\value{
A subset of the track table is \code{[} is called, or a modified version
 of the track table if \code{[<-} is called.
}
\description{
Accessing columns, rows, or cells via $, [[, or [ is mostly
 similar to regular \code{\link[base:Extract.data.frame]{data frames}}.
 However, the behavior is sometimes different for track tables based on
 \code{\link[tibble]{tibble}} and \code{\link[data.table]{data.table}}. For
 more info, refer to \link[tibble:subsetting]{tibble}'s and
 \code{\link[data.table]{data.table}}'s subsetting documentation.
}
\examples{
data(tracks)

tracks[1]
tracks[1, ]
tracks[1, 1]
tracks$id[tracks$id == "1"] <- "0"
tracks[tracks[, 1] == "0", 1] <- "1"

}
\seealso{
\code{\link{track_df}}, \code{\link{track_tbl}}, \code{\link{track_dt}}
}
\author{
Simon Garnier, \email{garnier@njit.edu}
}
