% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_esses.R
\name{calc_esses}
\alias{calc_esses}
\title{Calculates the Effective Sample Sizes from a parsed BEAST2 log file}
\usage{
calc_esses(traces, sample_interval)
}
\arguments{
\item{traces}{a dataframe with traces with removed burn-in}

\item{sample_interval}{the interval in timesteps between samples}
}
\value{
the effective sample sizes
}
\description{
Calculates the Effective Sample Sizes from a parsed BEAST2 log file
}
\examples{
  # Parse an example log file
  estimates_all <- parse_beast_log(
    get_tracerer_path("beast2_example_output.log")
  )

  # Remove burn-ins
  estimates <- remove_burn_ins(estimates_all,
    burn_in_fraction = 0.1
  )

  # Calculate the effective sample sizes of all parameter estimates
  esses <- calc_esses(
    estimates,
    sample_interval = 1000
  )

  expected <- c(10, 10, 10, 10, 7, 10, 9, 6)
  testit::assert(all(esses == expected))
}
\author{
Richèl J.C. Bilderbeek
}
