% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggstamp.R
\name{ggstamp}
\alias{ggstamp}
\title{Always stamp your plots with script name}
\usage{
ggstamp(plot, script = "no stamp", file, time = Sys.time())
}
\arguments{
\item{plot}{The plot to be stamped.}

\item{script}{the script name. Date and time will be added
automatically.}

\item{file}{An optional output filename to be included in the stamp.}

\item{time}{The timestamp to be included.}
}
\value{
the plot with a stamp

A plot object with the stamp added as caption
}
\description{
This function is used to stamp ggplot type plots with datetime and
script name. User must provide the script name.
}
\details{
The stamp is adding using the caption label. If a caption
is already in the plot, the stamp will be added in a new
line.

The caption is derived as
caption=paste(c(plot$label$caption,stamp,paste(date.txt,file)),collapse="\\n")

ggplot 2.2.1 (which is years old) or newer is required.
}
\examples{
library(ggplot2)
data(ChickWeight)
p1 <- ggplot(ChickWeight,aes(Time,weight,group=Chick,colour=factor(Diet)))+geom_line()
script <- "note"
ggstamp(p1,script)
## Or use ggwrite which will call ggstamp automatically.
ggwrite(p1,script=script,canvas="wide")
}
\seealso{
Other Plotting: 
\code{\link{canvasSize}()},
\code{\link{ggwater}()},
\code{\link{ggwrite}()}
}
\concept{Plotting}
