% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_index_peaks.R
\name{assign_index_peaks}
\alias{assign_index_peaks}
\title{Assign index peaks}
\usage{
assign_index_peaks(
  fragments_list,
  grouped = FALSE,
  index_override_dataframe = NULL
)
}
\arguments{
\item{fragments_list}{A list of "fragments_repeats" class objects representing
fragment data.}

\item{grouped}{Logical value indicating whether samples should be grouped to
share a common index peak. \code{FALSE} will assign the sample's own modal allele as the index peak. \code{TRUE} will use metadata to assign the index peak based on the modal peak of another sample (see below for more details).}

\item{index_override_dataframe}{A data.frame to manually set index peaks.
Column 1: unique sample IDs, Column 2: desired index peaks (the order of the
columns is important since the information is pulled by column position rather
than column name). Closest peak in each sample is selected so the number needs to just be approximate.}
}
\value{
This function modifies list of fragments_repeats objects in place with index_repeat and index_signal added.
}
\description{
Assign index peaks in preparation for calculation of instability metrics
}
\details{
A key part of instability metrics is the index peak. This is the repeat
length used as the reference peak for relative instability metrics calculations, like expansion index.
This is usually the the inherited repeat length of a mouse, or the modal repeat length for the cell line at a starting time point.

If \code{grouped} is set to \code{TRUE}, this function groups the samples by their \code{metrics_group_id} and uses the samples set as \code{metrics_baseline_control} to set the index peak. Use \code{\link[=add_metadata]{add_metadata()}} to set these variables. This is useful for cases like inferring repeat size of inherited alleles from mouse tail data. If the samples that are going to be used to assign index peak are from different fragment analysis runs, use \code{correction = "batch"} in \code{\link[=call_repeats]{call_repeats()}} to make sure the systematic differences between runs are corrected and the correct index peak is assigned. If there are multiple samples used as baseline control, the median value will be used to assign index peak to corresponding samples.

For mice, if just a few samples have the inherited repeat signal shorter than the expanded population, you could not worry about this and instead use the \code{index_override_dataframe}. This can be used to manually override these assigned index repeat values (irrespective of whether \code{grouped} is TRUE or FALSE).

As a final option, the index peak could be manually assigned directly to a \link{fragments_repeats} class using the internal setter function fragments_repeats$set_index_peak().
}
\examples{


fsa_list <- lapply(cell_line_fsa_list, function(x) x$clone())

find_ladders(fsa_list, show_progress_bar = FALSE)

fragments_list <- find_fragments(fsa_list,
  min_bp_size = 300
)

find_alleles(
  fragments_list
)
call_repeats(
  fragments_list
)

add_metadata(
  fragments_list,
  metadata_data.frame = trace::metadata
)

assign_index_peaks(
  fragments_list,
  grouped = TRUE
)

plot_traces(fragments_list[1], xlim = c(100,150))






}
