% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{sampling}
\alias{sampling}
\title{Sample Texts}
\usage{
sampling(id, corporaID, label, m, randomize = FALSE, exact = FALSE)
}
\arguments{
\item{id}{Character: IDs of all texts in the corpus.}

\item{corporaID}{List of Character: Each list element is a character vector and
contains the IDs belonging to one subcorpus. Each ID has to be in \code{id}.}

\item{label}{Named Logical: Labeling result for already labeled texts. Could be empty, if no labeled data exists. The algorithm sets \code{p = 0.5} for all intersections.
Names have to be \code{id}.}

\item{m}{Integer: Number of new samples.}

\item{randomize}{Logical: If \code{TRUE} calculated split is used as parameter
to draw from a multinomial distribution.}

\item{exact}{Logical: If \code{TRUE} exact calculation is used. For the default
\code{FALSE} an approximation is used.}
}
\value{
Character vector of IDs, which should be labeled next.
}
\description{
Sample texts from different subsets to minimize variance of the recall estimator
}
\examples{
id <- paste0("ID", 1:1000)
corporaID <- list(sample(id, 300), sample(id, 100), sample(id, 700))
label <- sample(as.logical(0:1), 150, replace=TRUE)
names(label) <- c(sample(id, 100), sample(corporaID[[2]], 50))
m <- 100
sampling(id, corporaID, label, m)
}
